unit Textlist;

interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, Quickrep, ExtCtrls;

type
  TTextRep = class(TForm)
    Rep: TQuickReport;
    QRBand1: TQRBand;
    QRLabel1: TQRLabel;
    QRBand2: TQRBand;
    QRBand3: TQRBand;
    QRSysData1: TQRSysData;
    QRSysData2: TQRSysData;
    QRSysData3: TQRSysData;
    QRLabel2: TQRLabel;
    procedure RepBeforePrint(var PrintReport: Boolean);
    procedure RepNeedData(var MoreData: Boolean);
    procedure RepAfterPrint(Sender: TObject);
  private
    { Private declarations }
    aFile : Text;
  public
    { Public declarations }
  end;

var
  TextRep: TTextRep;

implementation

{$R *.DFM}


procedure TTextRep.RepBeforePrint(var PrintReport: Boolean);
var
   aOpenDialog : TOpenDialog;
begin
   aOpenDialog:=TopenDialog.Create(self);
   with aOpenDialog do begin
      Filter:='Pascal files (*.PAS)|*.PAS|Text files (*.TXT)|*.TXT';
      options:=[ofFileMustExist];
      if not execute then PrintReport:=false
      else  begin
         AssignFile(aFile,Filename);
         reset(afile);
         Rep.ReportTitle:=Filename;
      end;
      free;
   end;
end;

procedure TTextRep.RepNeedData(var MoreData: Boolean);
var
   Line : String;
begin
   if not eof(aFile) then begin
      readln(aFile,Line);
      qrlabel1.caption:=Line;
      MoreData:=True;
   end
   else MoreData:=False;
end;

procedure TTextRep.RepAfterPrint(Sender: TObject);
begin
   CloseFile(aFile);
end;

end.
